#include <stdio.h>

int main ()
{
	// Le résultat d'un décalage gauche ou droit sur les entiers
	// signés négatifs n'est pas défini par le standard de C.

	// Du coup, il faut l'éviter : si on souhaite extraire certains
	// blocs de bits dans un entier, utiliser des "unsigned" pour
	// éviter des effets inattendus.

	// Dans GCC, le décalage droite pour les signés est un décalage
	// «arithmétique» qui divise par deux, le décalage gauche est
	// «logique» (le bit le plus significatif qui stocke le signe
	// est perdu).

	signed int b = 0xb0000000;
	unsigned int c = 0xb0000000;

	signed int lb = b << 1;
	signed int rb = b >> 1;
	unsigned int lc = c << 1;
	unsigned int rc = c >> 1;

	printf("b = %d (0x%x)\n",b,b);
	printf("b >> 1 = %d (0x%x)\n",rb,rb);
	printf("b << 1 = %d (0x%x)\n\n",lb,lb);

	printf("c = %u (0x%x)\n",c,c);
	printf("c >> 1 = %u (0x%x)\n",rc,rc);
	printf("c << 1 = %u (0x%x)\n",lc,lc);
}
