import Gates._

object Word
{
	type Word = Vector[Signal]
	type InputWord = Vector[Input]
	type LatchWord = Vector[Latch]

	implicit class ImpWord (val under: Word) extends AnyVal
	{
		def n = under.length
		def lower : Word = under.slice(0,n/2)
		def upper : Word = under.slice(n/2,n)
	}

	def Inputs (size:Int) : InputWord =
		Vector.tabulate(size)(_ => new Input)
	def Constant (size:Int)(value:Int) : Word =
		Vector.tabulate(size)(i =>
			if ((value & (1<<i)) != 0) One else Zero)

	implicit class ImpInput (val under: InputWord) extends AnyVal
	{
		def set (value:Int) : Unit =
			under.indices.foreach(i =>
				under(i).set((value & (1<<i)) != 0))
	}

	class Outputs (name:String, x:Word) extends Receptor
	{
		var count = 0
		var value = 0
		var n = x.length

		x.indices.foreach(i => x(i).subscribe(this,i))

		override def receive (id:Int, b:Boolean, d:Int)
		{
			Statistics.countDepth(d)
			if (b) value += 1<<id
			count += 1
			if (count < n) return

			println(name + " = " + value)
			value = 0
			count = 0
		}
	}

	def Latches (size:Int)(value:Int) : LatchWord =
		Vector.tabulate(size)(i => new Latch((value & (1<<i)) != 0))

	implicit class ImpLatch (val under: LatchWord) extends AnyVal
	{
		def toWord : Word = under.map(_.con)
		def connect (e:Signal, w:Word) : Unit =
			w.indices.foreach(i => under(i).connect(e,w(i)))
	}
}
