import Word._
import Logic._
import Gates._

object Select
{
	// Multiplexeur entre deux mots avec un seul bit de sélection
	def Mux (bit:Signal, x:Word, y:Word) : Word =
		Vector.tabulate(x.n)(i => Or(And(Not(bit),x(i)),And(bit,y(i))))

	// Multiplexeur général
	def Mux (sel:Word,v:Vector[Word]) : Word =
	{
		val k = sel.n
		assert(v.length == 1<<k)

		if (k == 1)
			Mux(sel(0),v(0),v(1))
		else
			Mux(sel.tail, Vector.tabulate(v.length/2)(i =>
					Mux(sel(0),v(2*i),v(2*i+1))))
	}

	// Décodeur produisant 2^n sorties, avec n la taille du mot "sel"
	def Decoder (sel:Word) : Word =
	{
		val bits = Vector(Not(sel(0)),sel(0))
		if (sel.n == 1)
			bits
		else
			Decoder(sel.tail).map(s =>
				Vector(And(s,bits(0)),And(s,bits(1)))).flatten
	}
}
